/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.jobs.LogListener;
import org.sonarlint.eclipse.core.internal.markers.MarkerUtils;
import org.sonarlint.eclipse.ui.internal.IssuesUpdater;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.console.SonarLintConsole;

public class SonarLintUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.sonarlint.eclipse.ui";
    private static SonarLintUiPlugin plugin;
    private IPropertyChangeListener prefListener;
    private LogListener logListener;

    public SonarLintUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.logListener = new LogListener(){

            public void info(String msg) {
                SonarLintUiPlugin.getSonarConsole().info(msg);
            }

            public void error(String msg) {
                SonarLintUiPlugin.getSonarConsole().error(msg);
            }

            public void debug(String msg) {
                SonarLintUiPlugin.getSonarConsole().debug(msg);
            }
        };
        SonarLintCorePlugin.getDefault().addLogListener(this.logListener);
        SonarLintUiPlugin.setupIssuesUpdater();
        this.prefListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("markerSeverity")) {
                    try {
                        MarkerUtils.updateAllSonarMarkerSeverity();
                    }
                    catch (CoreException e) {
                        SonarLintCorePlugin.getDefault().error("Unable to update marker severity", (Throwable)e);
                    }
                }
            }
        };
        this.getPreferenceStore().addPropertyChangeListener(this.prefListener);
    }

    public void stop(BundleContext context) throws Exception {
        SonarLintCorePlugin.getDefault().removeLogListener(this.logListener);
        try {
            this.getPreferenceStore().removePropertyChangeListener(this.prefListener);
        }
        finally {
            super.stop(context);
        }
    }

    public static SonarLintUiPlugin getDefault() {
        return plugin;
    }

    public static synchronized SonarLintConsole getSonarConsole() {
        IConsoleManager conMan = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (SonarLintConsole.TITLE.equals(existing[i].getName())) {
                return (SonarLintConsole)existing[i];
            }
            ++i;
        }
        SonarLintConsole myConsole = new SonarLintConsole(SonarLintImages.SONARLINT_CONSOLE_IMG_DESC);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("showConsole", "onError");
        store.setDefault("markerSeverity", 0);
        store.setDefault("extraArgs", "");
        store.setDefault("testFileRegexps", "**/*Test.*,**/test/**/*");
    }

    public static void setupIssuesUpdater() {
        final IssuesUpdater issuesUpdater = new IssuesUpdater();
        new UIJob("Prepare issues updater"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page = SonarLintUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.addPartListener((IPartListener2)issuesUpdater);
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

